//
//  GeometryGamesWebViewRep.swift
//
//  Created by Jeff on 26/11/20.
//  Copyright © 2020 Jeff Weeks. All rights reserved.
//

import UIKit
import SwiftUI
import WebKit


struct GeometryGamesWebViewRep: UIViewRepresentable {

	@Environment(\.locale) var locale

	@Binding var fileName: String
	
	func makeUIView(context: UIViewRepresentableContext<GeometryGamesWebViewRep>) -> WKWebView {

		return WKWebView()
	}
	
	func updateUIView(_ uiView: WKWebView, context: UIViewRepresentableContext<GeometryGamesWebViewRep>) {

		//	Design note:  We could, if we wished, write code like this
		//
		//		if let theFilePath = Bundle.main.path(forResource: fileName, ofType: "html") {
		//
		//		}
		//
		//	and let iOS locate an appropriate localized <fileName>.html file.
		//	The disadvantages of this approach are
		//
		//	1.	The individual .html files will all have the same name,
		//		risking confusion when editing them all at once.
		//
		//	2.	Each individual .html file must sit in its own <langID>.lproj folder,
		//		rather than sitting together with its siblings.
		//		This makes it harder to see them as a group,
		//		and also separates them from their shared .css and .png files,
		//		which sits one level higher up in the folder heirarchy.
		//
		//	3.	To top-level Help folder must be a "group" in Xcode,
		//		not a "folder reference", because a folder reference
		//		isn't allow to contain localized files within.
		//
		//	To avoid these problems, let's handle the localization manually.
		
		//	Each app's help files all live in the same "help" directory.
		//	The various localizations of a given file are distinguished
		//	by a language suffix, for example
		//
		//		help/<app name>-ar.html
		//		help/<app name>-en.html
		//		...
		//		help/<app name>-vi.html
		//		help/<app name>-zh-Hans.html
		//		help/<app name>-zh-Hant.html
		//
		//	Only Chinese uses a script tag.
		//
		let theLanguageCode = locale.languageCode ?? "en"
		let theFileSuffix: String
		if theLanguageCode == "zh" {
			let theScriptCode = locale.scriptCode ?? "Hans"
			theFileSuffix = "-" + theLanguageCode + "-" + theScriptCode
		} else {
			theFileSuffix = "-" + theLanguageCode
		}

		if let theFilePath = Bundle.main.path(
				forResource: fileName + theFileSuffix,
				ofType: "html",
				inDirectory: "help"
		) {
			let theFileURL = URL(fileURLWithPath: theFilePath, isDirectory: false)
			let theURLRequest = URLRequest(url: theFileURL)
			uiView.load(theURLRequest)
		}
	}
}
